/*
   This file shows how a C program can redirect
   its own standard streams to files. The main
   tool is the function
      freopen()
*/
#include <stdio.h>

int main( int argc, char *argv[])
{
   /* redirect this process's stdin and stdout to files */
   freopen("redirect_standard_streams.c", "r", stdin);
   freopen("test.txt", "w", stdout);

   /* do a simple filtering operation on stdin and write results to stdout */
   char c;
   while( (c = getchar()) != EOF )
      if ( c != 10 && c != 13 )
         printf("%c%c", c, c);
      else
         printf("%c", c);

   /* close the files */
   fclose(stdout);
   fclose(stdin);

   return 0;
}